
#IFDEF __STORY_DEBUG__
	Print __Alisha_._Project & " DevKit " & __Alisha_._Version_Pretty & " Core / String Support"
	WaitKey ( )

#ENDIF

declare Function Suffix ( Needle as string, Haystack as string ) as string

declare Function Prefix ( Needle as string, Haystack as string ) as string

declare Function strrpos ( Needle as string, Haystack as string ) as long

declare Function strpos ( Needle as string, Haystack as string ) as long

declare Function Ext_Suffix ( Needle as string, Haystack as string ) as string

declare Function Ext_Prefix ( Needle as string, Haystack as string ) as string

declare function AxisLabel_s ( Buffer as string, open_s As String = "[", close_s As String = "]" ) as string

declare function AxisParam_s ( Buffer as string, open_s As String = "[", close_s As String = "]" ) as string

declare function anicursor ( ) as string

declare function prompt ( label as string ) as string

declare Function Str_Replace ( Needle as string, Replacement as string, Haystack as string ) as string

Declare Function PackText ( Buffer As String = "", Newline As String = "" ) As String

Declare Function PackTextReverse ( Buffer As String = "", Newline As String = "" ) As String

Declare Function NeedleCount ( Needle As String = "", Haystack As String = "" ) As Long

Declare Function UCWords ( Subject As String ) As String

Declare Function Load_Buffer ( FullFilename As String ) As String

Declare Sub Dump_Buffer ( Buffer As String )

Function strrpos ( Needle as string, Haystack as string ) as long

	if len ( Needle )=0 then return len ( Haystack )+1

	if len ( Haystack )=0 then return len ( Haystack )+1

	dim as long temp

	temp=INSTRREV ( Haystack, Needle )

	if temp=0 then return len ( Haystack )+1

	Return temp

End Function

Function strpos ( Needle as string, Haystack as string ) as long

	if len ( Needle )=0 then return 0

	if len ( Haystack )=0 then return 0

	dim as long temp

	temp=INSTR ( Haystack, Needle )

	if temp=0 then return 0

	Return temp

End Function

Function Ext_Suffix ( Needle as string, Haystack as string ) as string

	return mid ( Haystack, strrpos ( Needle, Haystack )+len ( Needle ))

End Function

Function Ext_Prefix ( Needle as string, Haystack as string ) as string

	return left ( Haystack, strrpos ( Needle, Haystack )-1 )

End Function

Function Suffix ( Needle as string, Haystack as string ) as string

	dim as long o_i

	o_i=Instr ( Haystack, Needle )

	select case false

	case o_i=0

		Return Mid$ ( Haystack, o_i+Len ( Needle ))

	case else

		Return ""

	end select

End Function

Function Prefix ( Needle as string, Haystack as string ) as string

	Return Mid$ ( Haystack, 1, Instr ( Haystack, Needle )-1 )

End Function

function AxisLabel_s ( Buffer as string, open_s As String = "[", close_s As String = "]" ) as string

	dim as long o1_i

	o1_i=instr ( Buffer, open_s )

	dim as long o2_i

	o2_i=instr ( Buffer, close_s )

	select case cbool ( true )

	case cbool ( o1_i>0 ) andalso cbool ( o2_i=0 )

		return left$ ( Buffer, o1_i-1 )

	case cbool ( o2_i>o1_i )

		return left$ ( Buffer, o1_i-1 )

	case else

		return Buffer

	end select

end function

function AxisParam_s ( Buffer as string, open_s As String = "[", close_s As String = "]" ) as string

	dim as long o1_i

	o1_i=instr ( Buffer, open_s )

	dim as long o2_i

	o2_i=instr ( Buffer, close_s )

	select case cbool ( true )

	case cbool ( o1_i>0 ) andalso cbool ( o2_i=0 )

		return ""

	case cbool ( o1_i>0 ) andalso cbool ( o2_i>o1_i )

		return mid$ ( Buffer, o1_i+len ( open_s ), o2_i-o1_i-len ( open_s ))

	case else

		return ""

	end select

end function

function anicursor ( ) as string

	dim as long f=0

	f= ( fix ( timer*4 ) mod 4 ) + 1

	return mid ( "\|/-", f, 1 )

end function

function prompt ( label as string ) as string

	dim as string ci, value

	ci=""

	value=""

	locate csrlin, pos

	Print label;

	do

		ci=""

		do while len ( ci )=0

			Print anicursor ( );

			locate csrlin, pos-1

			ci=inkey ( )

			if ci=chr ( 27 ) then end

		loop

		select case len ( ci )

		case 1

			select case asc ( ci )

			case 27 'escape

				return ci

			case 8 'backspace

				if len ( value )>0 then

					value=left ( value, len ( value )-1 )

					locate csrlin, pos-1

					print " ";

					locate csrlin, pos-2

				end if

			case 13 'carriage return

				print " "

				return value

			case is >= 32 'valid text

				value+=ci

				Print ci;

			end select

		end select

	loop

end function

Function Str_Replace ( Needle as string, Replacement as string, Haystack as string ) as string

	dim as long Offset=0

	do

		Offset=strpos ( Needle, Haystack )

		if Offset=0 then exit do

		Haystack=Prefix ( Needle, Haystack ) & Replacement & Suffix ( Needle, Haystack )

	loop

	return Haystack

end function

Function PackText ( Buffer As String = "", Newline As String = "" ) As String

	If Len ( Buffer ) > 0 Then

		Buffer &= CRLF

	End If

	Buffer &= Newline

	Return Buffer

End Function

Function PackTextReverse ( Buffer As String = "", Newline As String = "" ) As String

	If Len ( Buffer ) > 0 Then

		Buffer = CRLF & Buffer

	End If

	Buffer = Newline & Buffer

	Return Buffer

End Function

Function NeedleCount ( Needle As String = "", Haystack As String = "" ) As Long

	Dim As Long Count = 0

	Dim As String Buffer

	Buffer = ""

	Do

		Buffer = Prefix ( Needle, Haystack )

		Haystack = Suffix ( Needle, Haystack )

		If Len ( Haystack ) > 0 Then

			Count += 1

		Else

			Exit Do

		End If

	Loop

	Return Count

End Function

Function UCWords ( Subject As String ) As String

	Dim As String Value = ""
	
	Do
	
		If Len ( Value ) > 0 Then
			Value &= SP
		End If
		
		Value &= UCase ( Left ( Prefix ( SP, Subject ) , 1 ) ) & LCase ( Mid ( Prefix ( SP, Subject ) , 2 ) )
		
		Subject = Suffix ( SP, Subject )
	
	Loop
	
	Return Value

End Function

Sub Dump_Buffer ( Buffer As String )

	Dim As String TempPrefix = ""
	Dim As String TempSuffix = Buffer
	
	Do
		
		TempPrefix = Prefix ( CRLF, TempSuffix )
		TempSuffix = Suffix ( CRLF, TempSuffix )
		
		If Len ( TempSuffix ) = 0 Then
			Exit Do
		End If
		
		Print TempPrefix
		
	Loop

	WaitKey ( )

End Sub

Function Load_Buffer ( FullFilename As String ) As String

	Dim As String Buffer
	Buffer = ""
	
	If Is_File ( FullFilename ) = 0 Then

		Color RGBA ( 255, 255, 255, 255 )

		Print "Is not a file: " & QUOT & FullFilename & QUOT

		WaitKey ( )


		Buffer = ""
		Return Buffer

	End If

	Dim As Long Filemode = Freefile

	If Filemode = 0 Then

		Buffer = ""
		Return Buffer

	End If

	If Open ( FullFilename For Binary As #Filemode ) Then

		Close #Filemode

		Filemode = 0

		Buffer = ""
		Return Buffer

	End If

	Buffer = Space ( Lof ( Filemode ) )

	Get #Filemode, 1, Buffer

	Close #Filemode

	Filemode = 0
	
	Return Buffer
	
End Function

